<?php

namespace App\Http\Controllers\Api\Branch\Delivery;

use App\Trait\ApiTrait;
use App\Models\Delivery;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Resources\DeliveryResource;
use App\Http\Requests\Delivery\StoreDeliveryRequest;
use App\Http\Requests\Delivery\UpdateDeliveryRequest;

class DeliveryController extends Controller
{
    use ApiTrait;

    public function index(Request $request)
    {
        $deliveries = Delivery::when($request->has('branch'), function ($query) use ($request) {
            return $query->where('branch_id', $request->branch);
        })->when(auth('company')->check(), function ($query) {
            return $query->whereIn('branch_id', auth('company')->user()->branches->pluck('id'));
        })->when($request->has('outer'), function ($query) {
            return $query->where('type', 'outer');
        })->when(auth('employee')->check(), function ($query) {
            return $query->whereIn('branch_id', auth('employee')->user()->company->branches->pluck('id'));
        })->get();
        return $this->apiResponse(data: DeliveryResource::collection($deliveries));
    }

    public function show(Delivery $delivery)
    {
        $delivery->load(['employee', 'branch']);
        return $this->apiResponse(data: new DeliveryResource($delivery));
    }

    public function store(StoreDeliveryRequest $request)
    {
        return $this->apiResponse(
            data: new DeliveryResource(Delivery::create($request->validated())),
            message: 'Delivery created successfully.'
        );
    }

    public function update(UpdateDeliveryRequest $request, Delivery $delivery)
    {
        $delivery->update($request->validated());
        return $this->apiResponse(
            data: new DeliveryResource($delivery),
            message: 'Delivery updated successfully.'
        );
    }

    public function destroy(Delivery $delivery)
    {
        $delivery->delete();
        return $this->apiResponse(message: 'Delivery deleted successfully.');
    }
}
