<?php

namespace App\Http\Controllers\Api\Branch;

use App\Trait\ApiTrait;
use Illuminate\Http\Request;
use App\Models\DismissalNotice;
use App\Http\Controllers\Controller;
use App\Http\Resources\DismissalNoticeResource;
use App\Http\Services\DismissalNotice\DismissalNoticeService;
use App\Http\Requests\Api\DismissalNotice\DismissalNoticeRequest;

class DismissalNoticeController extends Controller
{
    use ApiTrait;

    public function index(Request $request)
    {
        return $this->apiResponse(
            data: DismissalNoticeResource::collection(
                DismissalNotice::when(
                    $request->has('warehouse_id'),
                    fn ($query) => $query->where('warehouse_id', $request->warehouse_id)
                )->when(
                    $request->has('branch_id'),
                    fn ($query) => $query->where('branch_id', $request->branch_id)
                )->when(
                    $request->has('product_id'),
                    fn ($query) => $query->where('product_id', $request->product_id)
                )
                ->with([
                    'product',
                    'warehouse:id,name',
                    'branch:id,name',
                ])
                ->get()
            )
        );
    }

    public function store(DismissalNoticeRequest $request)
    {
        return $this->apiResponse(
            data: DismissalNoticeResource::make(DismissalNoticeService::createDismissal($request->validated())),
            message: "Dismissal notice created successfully.",
        );
    }

    public function show(DismissalNotice $dismissalNotice)
    {
        $dismissalNotice->load([
            'product',
            'warehouse',
            'branch',
        ]);

        return $this->apiResponse(
            data: DismissalNoticeResource::make($dismissalNotice),
        );
    }

    // public function update(Request $request, DismissalNotice $dismissalNotice)
    // {
    //     //
    // }

    public function destroy(DismissalNotice $dismissalNotice)
    {
        $dismissalNotice->delete();
        return $this->apiResponse(
            message: "Dismissal notice deleted successfully.",
        );
    }
}
