<?php

namespace App\Http\Controllers\Api\Branch;

use App\Trait\ApiTrait;
use Illuminate\Http\Request;
use App\Models\StockTransfer;
use App\Http\Helper\CompanyHelper;
use App\Http\Controllers\Controller;
use App\Http\Resources\StockTransferResource;
use App\Http\Services\StockTransfer\StockTransferService;
use App\Http\Requests\Api\StockTransfer\StoreStockTransferRequest;

class StockTransferController extends Controller
{
    use ApiTrait;

    public function index()
    {
        return $this->apiResponse(
            data: StockTransferResource::collection(
                CompanyHelper::getCompany()->stockTransfers()->with([
                    'product',
                    'fromWarehouse:id,name',
                    'toWarehouse:id,name',
                    'fromBranch:id,name',
                    'toBranch:id,name',
                ])->get()
            )
        );
    }

    public function store(StoreStockTransferRequest $request)
    {
        (new StockTransferService)->processTransfer($request);
        return $this->apiResponse(
            message: "Stock transfer created successfully.",
        );
    }

    public function show(StockTransfer $stockTransfer)
    {
        $stockTransfer->load([
            'product',
            'fromWarehouse:id,name',
            'toWarehouse:id,name',
            'fromBranch:id,name',
            'toBranch:id,name',
        ]);

        return $this->apiResponse(
            data: StockTransferResource::make($stockTransfer)
        );
    }

    public function destroy(StockTransfer $stockTransfer)
    {
        $stockTransfer->delete();
        return $this->apiResponse(
            message: "Stock transfer deleted successfully.",
        );
    }
}
