<?php

namespace App\Http\Controllers\Api\Category;

use App\Models\Category;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Requests\StoreCategoryRequest;
use App\Http\Requests\UpdateCategoryRequest;
use App\Http\Resources\CategoryResource;
use App\Trait\ApiTrait;

class CategoryController extends Controller
{
    use ApiTrait;

    public function index($type)
    {
        if ($type == 'all') {
            $categories = auth()->user()->categories;
        } elseif ($type == 'products') {
            $categories = auth()->user()->productsCategories;
        } elseif ($type == 'fast-services') {
            $categories = auth()->user()->servicesCategories->where('fast', 1);
        } else {
            $categories = auth()->user()->servicesCategories;
        }
        $categories = CategoryResource::collection($categories);
        return $this->apiResponse(data: $categories);
    }

    public function store(StoreCategoryRequest $request)
    {
        $category = Category::create($request->validated());
        $category = new CategoryResource($category);

        return $this->apiResponse(
            data: $category,
            message: 'Category created successfully.'
        );
    }
    public function update(UpdateCategoryRequest $request, $type,  Category $category)
    {
        $category->update($request->validated());
        $category = new CategoryResource($category);
        return $this->apiResponse(
            message: "Category update successful",
            data: $category
        );
    }

    public function destroy($type, Category $category)
    {
        $category->delete();
        return $this->apiResponse(
            message: "Category deleted successful",
        );
    }
}
