<?php

namespace App\Http\Controllers\Api\Client\Attribute;

use App\Models\Attribute;
use App\Http\Controllers\Controller;
use App\Http\Helper\CompanyHelper;
use App\Http\Requests\Api\Attribute\StoreAttributeRequest;
use App\Http\Requests\Api\Attribute\UpdateAttributeRequest;
use App\Http\Resources\AttributesResource;
use App\Trait\ApiTrait;

class AttributeController extends Controller
{
    use ApiTrait;

    public function index($model, $type)
    {
        return $this->apiResponse(
            data: AttributesResource::collection(CompanyHelper::getCompany()->clientAttributes($type, $model)->get())
        );
    }

    public function show($model, $type, Attribute $attribute)
    {
        return $this->apiResponse(data: AttributesResource::make($attribute));
    }

    public function store($model, StoreAttributeRequest $request)
    {
        return $this->apiResponse(
            data: AttributesResource::make(AttributesResource::make(
                Attribute::create(
                    [
                        'type' => $request->type,
                        'model' => $model,
                        'company_id' => CompanyHelper::getCompany()->id
                    ] + $request->validated()
                )
            )),
            message: $request->type . ' created successfully.'
        );
    }

    public function update($model, $type, UpdateAttributeRequest $request, Attribute $attribute)
    {
        $attribute->update($request->validated());

        return $this->apiResponse(
            data: AttributesResource::make($attribute),
            message: $request->type . ' updated successfully.'
        );
    }

    public function destroy($model, $type, Attribute $attribute)
    {
        $attribute->delete();
        return $this->apiResponse(message: $type . ' deleted successfully.');
    }
}
