<?php

namespace App\Http\Controllers\Api\Client\BlockClient;

use App\Trait\ApiTrait;
use App\Models\BlockClient;
use App\Http\Controllers\Controller;
use App\Http\Enums\User\UserStatusEnum;
use App\Http\Helper\CompanyHelper;
use App\Http\Requests\Api\Client\BlockClient\StoreBlockClientRequest;
use App\Http\Requests\Api\Client\BlockClient\UpdateBlockClientRequest;
use App\Http\Resources\BlockClientResource;

class BlockClientController extends Controller
{
    use ApiTrait;

    public function index()
    {
        return $this->apiResponse(
            data: BlockClientResource::collection(
                CompanyHelper::getCompany()
                    ->blockClients()
                    ->with(['client', 'blockReason'])
                    ->get()
            )
        );
    }

    public function store(StoreBlockClientRequest $request)
    {
        $blockClient = CompanyHelper::getCompany()->blockClients()->create(['company_id' => CompanyHelper::getCompany()->id] + $request->validated());
        $blockClient->client()->update(['status' => UserStatusEnum::BLOCKED->value]);

        return $this->apiResponse(
            data: BlockClientResource::make($blockClient),
            message: 'Client add to block list successfully.'
        );
    }

    public function update(UpdateBlockClientRequest $request, BlockClient $blockClient)
    {
        $blockClient->update($request->validated());

        return $this->apiResponse(
            data: BlockClientResource::make($blockClient),
            message: 'Client in block list data updated successfully.'
        );
    }

    public function destroy(BlockClient $blockClient)
    {
        $blockClient->client()->update(['status' => UserStatusEnum::INACTIVE->value]);
        $blockClient->delete();

        return $this->apiResponse(
            message: 'Client removed from the block list successfully.'
        );
    }
}
