<?php

namespace App\Http\Controllers\Api\Company;

use App\Models\Company;
use App\Http\Controllers\Controller;
use App\Http\Requests\Api\Company\StoreCompanyRequest;
use App\Http\Requests\Api\Company\UpdateCompanyRequest;
use App\Trait\ApiTrait;

class CompanyController extends Controller
{

    use ApiTrait;

    public function index()
    {
        // $this->authorize('viewAny',  auth()->user());
        $companies = Company::get();
        return $this->apiResponse(data: $companies);
    }


    public function store(StoreCompanyRequest $request)
    {
        $logo = $this->uploadFile(Company::UPLOADED_FILES, $request->logo);

        $company = Company::create(['logo' => $logo] + $request->validated());
        return $this->apiResponse(data: $company, message: 'Company Created successfully.');
    }

    public function show(Company $company)
    {

        // $this->authorize('view', ['company' => $company]);
        return $this->apiResponse(data: $company);
    }


    public function update(UpdateCompanyRequest $request, Company $company)
    {
        // $this->authorize('edit company', auth()->user());

        $company->update($request->validated());
        return $this->apiResponse(data: $company, message: 'Company Updated successfully.');
    }

    public function destroy(Company $company)
    {
        // $this->authorize('delete company', auth()->user());
        $company->delete();
        return $this->apiResponse(message: 'Company Deleted successfully.');
    }
}
