<?php

namespace App\Http\Controllers\Api\Company\Role;

use App\Trait\ApiTrait;
use Illuminate\Http\Request;
use Spatie\Permission\Models\Role;
use App\Http\Controllers\Controller;
use App\Http\Resources\RoleResource;
use App\Http\Requests\Api\Company\Role\StoreRoleRequest;
use App\Http\Requests\Api\Company\Role\AttachPermissionRequest;
use App\Http\Requests\Api\Company\Role\AttachWorkerPermissionRequest;
use App\Models\Worker;

class RoleController extends Controller
{
    use ApiTrait;

    public function index()
    {
        $this->authorize('view roles');
        $roles = RoleResource::collection(auth('company')->user()->roles);
        return $this->apiResponse(data: $roles);
    }

    public function show(Role $role)
    {
        $this->authorize('show roles');
        $role->load('permissions');
        $role = new RoleResource($role);
        return $this->apiResponse(data: $role);
    }

    public function store(StoreRoleRequest $request)
    {
        $this->authorize('create roles');
        $role = Role::create([
            'name' => $request->name,
            'guard_name' => 'worker',
            'company_id' => $request->user()->id
        ]);
        $role = new RoleResource($role);
        return $this->apiResponse(data: $role);
    }

    public function destroy(Role $role)
    {
        $this->authorize('delete roles');
        $role->delete();
        return $this->apiResponse(message: "Role deleted successfully.");
    }

    public function attachPermissions(AttachPermissionRequest $request, Role $role)
    {
        $this->authorize('edit roles');
        $role->syncPermissions($request->permissions);
        $role->load('permissions');
        $role = new RoleResource($role);
        return $this->apiResponse(message: "Permission has been attached successfully to role.");
    }

    public function attachWorkerPermission(AttachWorkerPermissionRequest $request, Worker $worker)
    {
        $worker->syncPermissions($request->permissions);
        return $this->apiResponse(message: "Permission has been attached successfully to worker.");
    }
}
