<?php

namespace App\Http\Controllers\Api\Company;

use App\Trait\ApiTrait;
use Illuminate\Http\Request;
use App\Http\Helper\CompanyHelper;
use App\Http\Controllers\Controller;
use App\Http\Requests\SellNature\StoreSellNatureRequest;
use App\Http\Resources\SellNatureResource;
use App\Models\MainSellNature;

class SellNatureController extends Controller
{
    use ApiTrait;

    public function index(Request $request)
    {
        return $this->apiResponse(data: [
            "all" => SellNatureResource::collection(MainSellNature::get()),
            "own" => SellNatureResource::collection(CompanyHelper::getCompany($request)->sellNatures),
        ]);
    }

    public function store(StoreSellNatureRequest $request)
    {
        CompanyHelper::getCompany($request)->sellNatures()->sync($request->main_sell_natures);
        return $this->apiResponse(message: "Sell natures successfully updated.");
    }
}
