<?php

namespace App\Http\Controllers\Api\Company\Tax;

use App\Http\Controllers\Controller;
use App\Http\Requests\Api\Company\Tax\StoreTaxRequest;
use App\Http\Requests\Api\Company\Tax\UpdateTaxRequest;
use App\Http\Resources\TaxResource;
use App\Models\Tax;
use App\Trait\ApiTrait;
use Illuminate\Http\Request;

class TaxController extends Controller
{
    use ApiTrait;

    public function index(Request $request)
    {
        $taxes = TaxResource::collection($request->user()->taxes);
        return $this->apiResponse(data: $taxes);
    }

    public function show(Tax $tax)
    {
        return $this->apiResponse(data: new TaxResource($tax));
    }

    public function store(StoreTaxRequest $request)
    {
        $tax = new TaxResource($request->user()->taxes()->create($request->validated()));
        return $this->apiResponse(data: $tax, message: "Tax created successfully.");
    }

    public function update(UpdateTaxRequest $request, Tax $tax)
    {
        $tax->update($request->validated());
        return $this->apiResponse(data: new TaxResource($tax), message: "Tax updated successfully.");
    }

    public function destroy(Tax $tax)
    {
        $tax->delete();
        return $this->apiResponse(message: "Tax deleted successfully.");
    }
}
