<?php

namespace App\Http\Controllers\Api\Company\TreasuryBankNetwork;

use App\Models\Bank;
use App\Trait\ApiTrait;
use App\Http\Helper\CompanyHelper;
use App\Http\Controllers\Controller;
use App\Http\Resources\BankResource;
use App\Http\Requests\Api\Company\Bank\StoreBankRequest;
use App\Http\Requests\Api\Company\Bank\UpdateBankRequest;

class BankController extends Controller
{
    use ApiTrait;

    public function index()
    {
        return $this->apiResponse(
            data: BankResource::collection(
                CompanyHelper::getCompany()->banks
            )
        );
    }

    public function store(StoreBankRequest $request)
    {
        return $this->apiResponse(data: new BankResource(
            CompanyHelper::getCompany()->banks()->create(['company_id' => auth('company')->id()] + $request->validated())
        ), message: "bank created successfully.");
    }

    public function show(Bank $bank)
    {
        return $this->apiResponse(data: new BankResource($bank));
    }

    public function update(UpdateBankRequest $request, Bank $bank)
    {
        $bank->update($request->validated());
        return $this->apiResponse(data: new BankResource($bank), message: "bank updated successfully.");
    }

    public function destroy(Bank $bank)
    {
        $bank->delete();
        return $this->apiResponse(message: "bank deleted successfully.");
    }
}
