<?php

namespace App\Http\Controllers\Api\Company\TreasuryBankNetwork;

use App\Trait\ApiTrait;
use App\Models\Treasury;
use App\Http\Controllers\Controller;
use App\Http\Resources\TreasuryResource;
use App\Http\Requests\Api\Company\Treasury\StoreTreasuryRequest;
use App\Http\Requests\Api\Company\Treasury\UpdateTreasuryRequest;

class TreasuryController extends Controller
{
    use ApiTrait;

    public function index()
    {
        return $this->apiResponse(data: TreasuryResource::collection(Treasury::where('company_id', auth('company')->id())->get()));
    }

    public function store(StoreTreasuryRequest $request)
    {
        return $this->apiResponse(data: new TreasuryResource(Treasury::create(['company_id' => auth('company')->id()] + $request->validated())), message: "treasury created successfully.");
    }

    public function show(Treasury $treasury)
    {
        return $this->apiResponse(data: new TreasuryResource($treasury));
    }

    public function update(UpdateTreasuryRequest $request, Treasury $treasury)
    {
        $treasury->update($request->validated());
        return $this->apiResponse(data: new TreasuryResource($treasury), message: "treasury updated successfully.");
    }

    public function destroy(Treasury $treasury)
    {
        $treasury->delete();
        return $this->apiResponse(message: "treasury deleted successfully.");
    }
}
