<?php

namespace App\Http\Controllers\Api\Company\Unit;

use App\Models\Company;
use App\Trait\ApiTrait;
use App\Models\MainUnit;
use App\Models\CompanyUnit;
use App\Http\Controllers\Controller;
use App\Http\Requests\Api\Company\Unit\StoreCompanyUnitRequest;
use App\Http\Requests\Api\Company\Unit\UpdateCompanyUnitRequest;
use App\Http\Resources\UnitResource;

class CompanyUnitController extends Controller
{
    use ApiTrait;

    public function index()
    {
        $units = Company::find(auth()->id())->units;
        $units = UnitResource::collection($units);
        return $this->apiResponse(data:$units);
    }

    public function store(StoreCompanyUnitRequest $request)
    {
        $unit = Company::find(auth()->id())->units()->create($request->validated());
        $unit = new UnitResource($unit);
        return $this->apiResponse(data:$unit, message:'Unit created successfully.');

    }

    public function update(UpdateCompanyUnitRequest $request, CompanyUnit $companyUnit)
    {
        $companyUnit->update($request->validated());
        $unit = new UnitResource($companyUnit);
        return $this->apiResponse(data:$unit, message:'Unit updated successfully.');
    }

    public function destroy(CompanyUnit $companyUnit)
    {
        $companyUnit->delete();
        return $this->apiResponse(message:'Unit deleted successfully.');
    }
}
