<?php

namespace App\Http\Controllers\Api\Company\VacationRequest;

use App\Trait\ApiTrait;
use Illuminate\Http\Request;
use App\Models\VacationRequest;
use App\Http\Controllers\Controller;
use App\Http\Resources\VacationRequestResource;
use App\Http\Requests\Api\Company\VacationRequest\StoreVacationRequestRequest;
use App\Http\Requests\Api\Company\VacationRequest\UpdateVacationRequestRequest;
use App\Http\Requests\Api\Company\VacationRequest\ChangeVacationRequestStatusRequest;

class VacationRequestController extends Controller
{
    use ApiTrait;

    public function index(Request $request)
    {

        $vacationRequests = VacationRequestResource::collection($request->user()->vacationRequests()->with([
            'employee',
            'vacation',
            'substituteEmployee',
        ])->get());
        return $this->apiResponse(data: $vacationRequests);
    }

    public function show(VacationRequest $vacationRequest)
    {
        $vacationRequest->load([
            'employee',
            'vacation',
            'substituteEmployee',
        ]);
        $vacationRequest = new VacationRequestResource($vacationRequest);
        return $this->apiResponse(data: $vacationRequest);
    }

    public function store(StoreVacationRequestRequest $request)
    {
        $vacationRequest = new VacationRequestResource($request->user()->vacationRequests()->create($request->validated()));
        return $this->apiResponse(data: $vacationRequest, message: "Vacation request successfully created.");
    }

    public function update(UpdateVacationRequestRequest $request, VacationRequest $vacationRequest)
    {
        $vacationRequest->update($request->validated());
        $vacationRequest = new VacationRequestResource($vacationRequest);
        return $this->apiResponse(data: $vacationRequest, message: "Vacation request updated successfully.");
    }

    public function changeStatus(ChangeVacationRequestStatusRequest $request, VacationRequest $vacationRequest)
    {
        $vacationRequest->update(['accepted' => $request->status]);
        return $this->apiResponse(data: new VacationRequestResource($vacationRequest), message: "Vacation request updated successfully.");
    }

    public function destroy(VacationRequest $vacationRequest)
    {
        $vacationRequest->delete();
        return $this->apiResponse(message: "Vacation request deleted successfully.");
    }
}
