<?php

namespace App\Http\Controllers\Api\Company\Worker;

use App\Http\Controllers\Controller;
use App\Http\Requests\Api\Company\Worker\StoreWorkerRequest;
use App\Http\Requests\Api\Company\Worker\UpdateWorkerRequest;
use App\Http\Resources\WorkerResource;
use App\Models\Worker;
use App\Trait\ApiTrait;
use App\Trait\UploadFileTrait;
use Illuminate\Http\Request;

class WorkerController extends Controller
{
    use ApiTrait, UploadFileTrait;

    public function index(Request $request)
    {
        $workers = WorkerResource::collection($request->user()->workers()->with(['employee', 'role'])->get());
        return $this->apiResponse(data: $workers);
    }

    public function store(StoreWorkerRequest $request)
    {
        if ($request->has('image')) {
            $image = $this->uploadFile(Worker::UPLOADED_FILES, $request->image);
        }
        $worker = new WorkerResource($request->user()->workers()->create(['image' => $image ?? null] + $request->validated()));
        return $this->apiResponse(data: $worker);
    }

    public function show(Worker $worker)
    {
        $worker->load([
            'employee',
            'role',
        ]);
        $worker = new WorkerResource($worker);
        return $this->apiResponse(data: $worker);
    }

    public function update(UpdateWorkerRequest $request, Worker $worker)
    {

        $image = $request->has('image') ? $this->uploadFile(Worker::UPLOADED_FILES, $request->image, $worker->image) : $worker->image;

        $worker->update(['image' => $image] + $request->validated());
        $worker = new WorkerResource($worker);
        return $this->apiResponse(data: $worker);
    }

    public function destroy(Worker $worker)
    {
        $worker->delete();
        return $this->apiResponse(message: "Worker deleted successfully.");
    }
}
