<?php

namespace App\Http\Controllers\Api\Employee\Attendance;

use App\Trait\ApiTrait;
use Illuminate\Http\Request;
use App\Models\AttendanceMethod;
use App\Http\Controllers\Controller;
use App\Http\Resources\AttendanceMethodResource;
use App\Http\Requests\Api\AttendanceMethod\StoreAttendanceMethodRequest;
use App\Http\Requests\Api\AttendanceMethod\UpdateAttendanceMethodRequest;

class AttendanceMethodController extends Controller
{
    use ApiTrait;

    public function index(Request $request)
    {
        $company = $request->user();
        $attendanceMethods = $company->attendanceMethods;
        $attendanceMethods = AttendanceMethodResource::collection($attendanceMethods);
        return $this->apiResponse(data: $attendanceMethods);
    }

    public function show(AttendanceMethod $attendanceMethod)
    {
        $attendanceMethod = new AttendanceMethodResource($attendanceMethod);
        return $this->apiResponse(data: $attendanceMethod);
    }

    public function store(StoreAttendanceMethodRequest $request)
    {
        $company = $request->user();
        $attendanceMethod = $company->attendanceMethods()->create($request->validated());
        $attendanceMethod = new AttendanceMethodResource($attendanceMethod);
        return $this->apiResponse(message: 'AttendanceMethod created successfully.', data: $attendanceMethod);
    }

    public function update(UpdateAttendanceMethodRequest $request, AttendanceMethod $attendanceMethod)
    {
        $attendanceMethod->update($request->validated());
        $attendanceMethod = new AttendanceMethodResource($attendanceMethod);
        return $this->apiResponse(message: 'AttendanceMethod updated successfully.', data: $attendanceMethod);;
    }
    public function destroy(AttendanceMethod $attendanceMethod)
    {
        $attendanceMethod->delete();
        return $this->apiResponse(message: 'AttendanceMethod deleted successfully.');;
    }
}
