<?php

namespace App\Http\Controllers\Api\Employee\Auth;

use App\Models\Worker;
use App\Trait\ApiTrait;
use App\Models\Employee;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;
use Illuminate\Validation\ValidationException;
use App\Http\Requests\Api\Employee\Auth\LoginRequest;
use App\Http\Resources\EmployeeResource;

class AuthController extends Controller
{
    use ApiTrait;

    public function login(LoginRequest $request)
    {
        $employee = Employee::where('code', $request->code)->first();
        if (!$employee || !Hash::check($request->password, $employee->password)) {
            throw ValidationException::withMessages([
                'code' => [
                    'invalid code or password, please try again.',
                ]
            ]);
        }
        $token = $employee->createToken('employee')->plainTextToken;
        $employee->load('branch');
        return $this->apiResponse(
            data: [
                'token' => $token,
                'employee' => EmployeeResource::make($employee)
            ],
            message: "Successfully Logged in."
        );

    }
}
