<?php

namespace App\Http\Controllers\Api\Employee;

use App\Models\Address;
use App\Trait\ApiTrait;
use App\Models\Employee;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Resources\EmployeeResource;
use App\Http\Requests\Api\Employee\Employee\StoreEmployeeRequest;
use App\Http\Requests\Api\Employee\Employee\UpdateEmployeeRequest;
use Illuminate\Support\Facades\Hash;

class EmployeeController extends Controller
{
    use ApiTrait;

    public function index(Request $request)
    {
        $company = $request->user();
        $employees = $company->employees;
        $employees = EmployeeResource::collection($employees);
        return $this->apiResponse(data: $employees);
    }

    public function show(Employee $employee)
    {
        $employee->load([
            'address.area.city.country',
            'section',
            'career',
            'attendanceMethod',
            'branch'
        ]);
        $employee = new EmployeeResource($employee);
        return $this->apiResponse(data: $employee);
    }

    public function store(StoreEmployeeRequest $request)
    {
        $company = $request->user();
        $address = Address::create($request->only([
            'address_line',
            'area_id',
            'post_code',
        ]));
        $employee = $company->employees()->create(['address_id' => $address->id, 'password' => Hash::make(Employee::PASSWORD)] + $request->validated());
        $employee = new EmployeeResource($employee);
        return $this->apiResponse(message: 'Employee created successfully.', data: $employee);
    }

    public function update(UpdateEmployeeRequest $request, Employee $employee)
    {
        $employee->update($request->validated());
        $employee->address()->update($request->only([
            'address_line'
        ]));
        $employee->load([
            'address',
            'section',
            'career',
            'attendanceMethod',
            'branch'
        ]);
        $employee = new EmployeeResource($employee);
        return $this->apiResponse(message: 'Employee updated successfully.', data: $employee);;
    }

    public function destroy(Employee $employee)
    {
        $employee->delete();
        return $this->apiResponse(message: 'Employee deleted successfully.');;
    }
}
