<?php

namespace App\Http\Enums\Bound;

enum BoundTypeEnum: int
{
    case PAYMENTS = 0;
    case RECEIVABLES = 1;


    public static function values(): array
    {
        return [
            'payments' => self::PAYMENTS->value,
            'receivables' => self::RECEIVABLES->value,
        ];
    }

    public static function getValueFromString(string $name): int
    {
        return match ($name) {
            strtolower(self::PAYMENTS->name) => self::PAYMENTS->value,
            strtolower(self::RECEIVABLES->name) => self::RECEIVABLES->value,
            default => self::PAYMENTS->value,
        };
    }
}
