<?php

namespace App\Http\Repositories;

use App\Http\Interfaces\BranchRepositoryInterface;
use App\Models\Branch;
use App\Models\DropdownOption;

class BranchRepository implements BranchRepositoryInterface
{
    public function all()
    {
        return Branch::with(['users', 'address'])->get();
    }

    public function paginate($count)
    {
        return Branch::with(['users','address' ])->paginate($count);
    }

    public function allemployeeCounts()
    {
        return DropdownOption::where('dropdown_name', 'employee_count')->get();
    }

    public function allWorkTypes()
    {
        return DropdownOption::where('dropdown_name', 'work_type')->get();
    }


    public function store($data)
    {
        return Branch::create($data);
    }

    public function destroy($id)
    {
        return Branch::findORfail($id)->delete();

    }

    public function update($data, $id)
    {
        // Job::findOrFail($id)->update($data);
    }
}
