<?php

namespace App\Http\Repositories;

use App\Models\Category;
use App\Http\Interfaces\CategoryRepositoryInterface;

class CategoryRepository implements CategoryRepositoryInterface
{
    public function getAll($type)
    {
        if ($type == 'all') {
            $categories = auth()->user()->categories;
        } elseif ($type == 'products') {
            $categories = auth()->user()->productsCategories;
        } else {
            $categories = auth()->user()->servicesCategories;
        }
        return $categories;
    }
    public function create($data)
    {
        $category = Category::create($data);
        return $category;
    }
    public function update($data, Category $category)
    {
        $category->update($data);
        return $category;
    }
    public function delete(Category $category)
    {
        $category->delete();
    }
}
