<?php

namespace App\Http\Repositories;

use App\Http\Interfaces\EmployeeRepositoryInterface;
use App\Models\User as Employee;

class EmployeeRepository implements EmployeeRepositoryInterface
{
    public function all()
    {
        return Employee::where('role', 0)->get();
    }
    
    public function paginate($count)
    {
        return Employee::where('role', 0)->with(['job', 'job.jobDepartment', 'address', 'address.area', 'address.area.city', 'address.area.city.country'])->paginate($count);
    }
    
    public function withAttendMethod($id)
    {
        return Employee::where('attend_method_id', $id)->get();
    }

    public function newCode()
    {
        return Employee::get()->last()->id + 1;
    }

    public function findById($id)
    {
        return Employee::findOrFail($id);
    }
    
    public function store($data)
    {
        Employee::create($data);
    }

    public function destroy($id)
    {
        return Employee::findOrFail($id)->delete();

    }

    public function update($data, $id)
    {
        Employee::findOrFail($id)->update($data);
    }
}