<?php

namespace App\Http\Repositories;
use App\Http\Interfaces\JobDepartmentRepositoryInterface;
use App\Models\JobDepartment;

class JobDepartmentRepository implements JobDepartmentRepositoryInterface
{
    public function all()
    {
        return JobDepartment::all();
    }

    public function paginate($count)
    {
        return JobDepartment::paginate($count);
    }

    public function get()
    {
        return JobDepartment::all();
    }

    public function store($data)
    {
        return JobDepartment::create($data);
    }

    public function destroy($id)
    {
        $department = JobDepartment::findOrFail($id);
        $department->delete();

    }

    public function update($data, $id)
    {
        $department = JobDepartment::findOrFail($id);
        return $department->update($data);
    }
}