<?php

namespace App\Http\Requests\Api\Client\BlockClient;

use App\Models\BlockClient;
use Illuminate\Foundation\Http\FormRequest;

class UpdateBlockClientRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return BlockClient::ROLE;
    }

    public function prepareForValidation()
    {
        $this->merge([
            'status' => $this->status == 'on',
        ]);
    }
}
