<?php

namespace App\Http\Requests\Api\Client\BlockReason;

use App\Models\BlockReason;
use Illuminate\Foundation\Http\FormRequest;

class UpdateBlockReasonRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return BlockReason::ROLE;
    }

    public function prepareForValidation()
    {
        $this->merge([
            'dropdown_name' => [
                'ar' => $this->dropdown_name_ar,
                'en' => $this->dropdown_name_en
            ],
            'option_value' => [
                'ar' => $this->option_value_ar,
                'en' => $this->option_value_en
            ],

        ]);
    }
}
