<?php

namespace App\Http\Requests\Api\Company\Role;

use App\Models\Company;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\ValidationException;

class AttachPermissionRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return Company::PERMISSIONS_RULES;
    }

    public function withValidator()
    {
        if ($this->role->company_id !== auth('company')->id()) {
            throw ValidationException::withMessages(['role' => 'invalid role.']);
        }
    }
}
