<?php

namespace App\Http\Requests\Api\Company\Vacation;

use App\Models\Vacation;
use Illuminate\Foundation\Http\FormRequest;

class StoreVacationRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return Vacation::RULES;
    }

    public function prepareForValidation()
    {
        $this->merge([
            'deducted_weekly' => $this->deducted_weekly == 'on',
            'year_to_year' => $this->year_to_year == 'on',
            'all' => $this->all == 'on',
            'status' => $this->status == 'on',
            'name' => [
                'ar' => $this->name_ar,
                'en' => $this->name_en,
            ],
        ]);
    }
}
