<?php

namespace App\Http\Requests\Api\Company\Worker;

use App\Models\Worker;
use Illuminate\Validation\Rule;
use Illuminate\Foundation\Http\FormRequest;

class StoreWorkerRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return array_merge(Worker::RULES, [
            'employee_id' => [
                'required',
                'exists:employees,id,company_id,' . auth()->id(),
                // 'unique:workers,employee_id,deleted_at,'
                Rule::unique('workers', 'employee_id')->where(function ($query) {
                    $query->whereNull('deleted_at');
                }),
            ],
            'role_id' => 'required|exists:roles,id,company_id,' . auth()->id(),
        ]);
    }

    public function prepareForValidation()
    {
        $this->merge([
            'status' => $this->status == 'on'
        ]);
    }
}
