<?php

namespace App\Http\Requests\Api\Journal;

use App\Http\Helper\CompanyHelper;
use Illuminate\Foundation\Http\FormRequest;

class StoreJournalRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $company = CompanyHelper::getCompany(request());
        return [
            // 'name' => 'required|string',
            'description' => 'required|string',
            'date' => 'required|date',
            'file' => 'nullable|file',

            'accounts' => 'required|array',
            'accounts.*.amount' => 'required|numeric|min:0.01',
            'accounts.*.account' => 'required|exists:accounts,id,company_id,' . $company->id,
            'accounts.*.type' => 'required|in:credit,debit',

            // 'debit' => 'required|array',
            // 'debit.*.amount' => 'required|numeric|min:0.01',
            // 'debit.*.account' => 'required|exists:accounts,id,company_id,' . $company->id,

            // 'credit' => 'required|array',
            // 'credit.*.amount' => 'required|numeric|min:0.01',
            // 'credit.*.account' => 'required|exists:accounts,id,company_id,' . $company->id,
        ];
    }
}
