<?php

namespace App\Http\Requests\Api\OpenBalance;

use App\Http\Helper\CompanyHelper;
use Illuminate\Foundation\Http\FormRequest;

class StoreOpenBalanceRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $company = CompanyHelper::getCompany(request());
        return [
            'date' => 'required|date',
            'products' => 'required|array',
            'products.*.product_id' => 'required|exists:products,id,company_id,' .  $company->id,
            'products.*.warehouse_id' => [
                'required',
                'exists:warehouses,id,company_id,' .  $company->id,
            ],
            'products.*.unit_id' => [
                'required',
                'exists:company_units,id,company_id,' .  $company->id,
            ],
            'products.*.quantity' => 'required|integer|min:1',
            'products.*.price' => 'required|integer|min:1',
        ];
    }
}
