<?php

namespace App\Http\Requests\Api\Warehouse;

use App\Models\Warehouse;
use Illuminate\Foundation\Http\FormRequest;

class UpdateWarehouseRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return Warehouse::RULES;
    }

    public function prepareForValidation()
    {
        $this->merge([
            'status' => $this->status == 'on' ? 1 : 0,
            'name' => [
                'ar' => $this->name_ar,
                'en' => $this->name_en,
            ],
        ]);
    }
}
