<?php

namespace App\Http\Resources;

use App\Models\Client;
use App\Models\Employee;
use App\Models\Supplier;
use Illuminate\Http\Resources\Json\JsonResource;

class BoundResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'date' => $this->date,
            'description' => $this->description,
            'customer' => $this->whenLoaded('entry'),
            'customer_type' => $this->whenLoaded('entry', function () {
                return match ($this->entry) {
                    $this->entry instanceof Client => 'client',
                    $this->entry instanceof Employee => 'employee',
                    $this->entry instanceof Supplier => 'supplier',
                    default => 'client',
                };
            }),
            'payment' => $this->whenLoaded('payment'),
            'file' => $this->file,
            'ref_number' => $this->ref_number,
            'tax_number' => $this->tax_number,
            'payment_method' => PaymentMethodResource::make($this->whenLoaded('payment_method')),
            'value' => $this->value,
            // 'tax' => TaxResource::make($this->whenLoaded('tax')),
        ];
    }
}
