<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class ClientResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            "id" => $this->id,
            "code" => $this->code,
            "membership_number" => $this->membership_number,
            "name" => $this->name,
            "image" => $this->image,
            "phone" => $this->phone,
            "email" => $this->email,
            "id_number" => $this->id_number,
            "birth_date" => $this->birth_date,
            "work_phone" => $this->work_phone,
            "gender" => $this->gender,
            "job_name" => $this->job_name,
            "favorite_employee_id" => $this->favorite_employee_id,
            "crn" => $this->crn,
            "trn" => $this->trn,
            "note" => $this->note,
            "status" => $this->status,
            "special" => $this->special,
            "is_client" => $this->is_client,
            "cache" => $this->cache,
            "internet" => $this->internet,
            "fingerprint" => $this->fingerprint,
            "balance" => $this->whenLoaded('entries', function () {
                return (number_format(
                    abs(
                        $this->entries->where('status', 'debit')->sum('amount')
                            - $this->entries->where('status', 'credit')->sum('amount')
                    ),
                    2
                ));
            }),
            'medical' => $this->medical,
            'medical_history' => $this->medical_history,
            'contact_info' => $this->contact_info,
            'extra_data' => $this->extra_data,
            "title" => new AttributesResource($this->whenLoaded('title')),
            "group" => new AttributesResource($this->whenLoaded('group')),
            "address" => new AddressResource($this->whenLoaded('address')),
            "entries" => EntryResource::collection($this->whenLoaded('entries')),
        ];
    }
}
