<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class JournalResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'date' => $this->date,
            'type' => $this->type,
            'source' => $this->source,
            'description' => $this->description,
            'file' => $this->file,
            'value' => $this->whenLoaded('journalable', function () {
                return [
                    'quantity' => $this->journalable->billProducts?->first()?->quantity,
                    'unit' => new UnitResource($this->journalable->billProducts?->first()?->unit),
                ];
            }),
            'journalable' => $this->whenLoaded('journalable'),
            'employee' => new EmployeeResource($this->whenLoaded('employee')),
            'entries' => EntryResource::collection($this->whenLoaded('entries')),
            'status' => $this->status,
            'created_at' => $this->created_at,
        ];
    }
}
