<?php

namespace App\Http\Resources;

use Carbon\Carbon;
use Illuminate\Http\Resources\Json\JsonResource;

class PermissionRequestResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'from' => $this->from->format('Y-m-d\TH:i'),
            'to' => $this->to->format('Y-m-d\TH:i'),
            'note' => $this->note,
            'employee' => new EmployeeResource($this->whenLoaded('employee')),
            // 'vacation' => new VacationResource($this->whenLoaded('vacation')),
            // 'substitute_employee' => new EmployeeResource($this->whenLoaded('substituteEmployee')),
        ];
    }
}
