<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class ProductResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'key' => $this->key,
            'code' => $this->code,
            'name' => $this->name,
            'name_ar' => $this->getTranslations('name')['ar'],
            'name_en' => $this->getTranslations('name')['en'],
            'barcode' => $this->barcode,
            'description' => $this->description,
            "description_ar" => $this->getTranslations('description')['ar'],
            "description_en" => $this->getTranslations('description')['en'],
            'category_id' => $this->category_id,
            'category' => new CategoryResource($this->whenLoaded('category')),
            // 'size' => $this->size,
            'inventory_type' => $this->inventory_type,
            'has_expiry_date' => $this->has_expiry_date,
            'status' => $this->status,
            'type' => $this->type,
            'tax' => TaxResource::make($this->whenLoaded('tax')),
            'units' => ProductUnitResource::collection($this->whenLoaded('units')),
            'warehouses' => ProductWarehouseResource::collection($this->whenLoaded('warehouses')),
        ];
    }
}
