<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class SupplierResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'name_ar' => $this->getTranslations('name')['ar'],
            'name_en' => $this->getTranslations('name')['en'],
            'code' => $this->code,
            'phone' => $this->phone,
            'phone_2' => $this->phone_2,
            'status' => $this->status,
            'note' => $this->note,
            "balance" => $this->whenLoaded('entries', function () {
                return (number_format(
                    abs(
                        $this->entries->where('status', 'debit')->sum('amount')
                            - $this->entries->where('status', 'credit')->sum('amount')
                    ),
                    2
                ));
            }),
            'address' =>  new AddressResource($this->whenLoaded('address')),
            "entries" => EntryResource::collection($this->whenLoaded('entries')),
        ];
    }
}
