<?php

namespace App\Http\Resources;

use App\Models\Company;
use App\Trait\ApiTrait;
use Illuminate\Http\Resources\Json\JsonResource;

class UserResource extends JsonResource
{
    use ApiTrait;
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'id' => $this['id'],
            'name' => $this['name'],
            'email' => $this['email'],
            'phone' => $this['phone'],
            'lang' => $this['lang'],
            // 'logo' => $this['logo'],
            'logo' => $this->logo ? $this->with_base(Company::UPLOADED_FILES . "/" .$this->logo) : $this->with_base(Company::UPLOADED_FILES . "/default_image.jpg"),

        ];
    }
}
