<?php

namespace App\Http\Resources;

use App\Models\Worker;
use App\Trait\ApiTrait;
use Illuminate\Http\Resources\Json\JsonResource;

class WorkerResource extends JsonResource
{
    use ApiTrait;
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'employee' => new EmployeeResource($this->whenLoaded('employee')),
            'role' => new RoleResource($this->whenLoaded('role')),
            'image' => $this->image ?
                $this->with_base(Worker::UPLOADED_FILES . "/" . $this->image) :
                $this->with_base(Worker::UPLOADED_FILES . "/default_image.jpg"),

            'status' => $this->status ? 'on' : 'off',
            'employee_id' => $this->employee_id,
            'role_id' => $this->role_id,
        ];
    }
}
