<?php

namespace App\Http\Services\Bound;

use App\Models\Bound;
use App\Models\Journal;
use Illuminate\Support\Facades\DB;
use App\Http\Enums\Bound\BoundTypeEnum;
use App\Http\Requests\Api\Bound\BoundRequest;
use App\Http\Services\Account\JournalService;
use App\Trait\BoundHelperTrait;

class BoundService
{
    use BoundHelperTrait;

    private Bound $bound;

    // public function __construct()
    // {
    //     define('DESCRIPTION', ucfirst(request()->route()->type) . " voucher.");
    // }

    public function create(BoundRequest $request)
    {
        DB::beginTransaction();

        // create bound.
        $this->bound = Bound::create($request->all());

        // create journals for bounds.
        $this->createJournal();

        DB::commit();

        return $this->bound;
    }
}
