<?php

namespace App\Listeners;

use App\Events\NewCompany;
use App\Models\BranchMainSettings;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;

class CompanyMainSettings
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  \App\Events\NewCompany  $event
     * @return void
     */
    public function handle(NewCompany $event)
    {
        $main_settings = BranchMainSettings::get();
        foreach ($main_settings as $setting) {
            $event->company->mainSettings()->create([
                'branch_main_settings_id' => $setting->id
            ]);
        }
    }
}
