<?php

namespace App\Models;

use App\Models\Client;
use Illuminate\Database\Eloquent\Model;
use Spatie\Translatable\HasTranslations;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Address extends Model
{
    use HasFactory, HasTranslations, SoftDeletes;

    const RULES = [
        'address_line' => 'nullable',
        'address_line_ar' => 'nullable|string',
        'address_line_en' => 'nullable|string',
        'post_code' => 'nullable',
        'area_id' => 'nullable|exists:countries,id',
        'longitude' => 'nullable',
        'latitude' => 'nullable',
    ];

    protected $fillable = [
        'address_line',
        'post_code',
        'area_id',
        'longitude',
        'latitude'
    ];

    public $translatable = ['address_line'];

    function area()
    {
        return $this->belongsTo(Country::class, 'area_id');
    }

    function user()
    {
        return $this->hasOne(User::class);
    }


    function client()
    {
        return $this->hasOne(Client::class);
    }

    function supplier()
    {
        return $this->hasOne(Supplier::class);
    }

    function employee()
    {
        return $this->hasOne(Employee::class);
    }
}
