<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Spatie\Translatable\HasTranslations;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Attribute extends Model
{
    use HasFactory, HasTranslations;

    const ROLE = [
        'name' => 'nullable',
        'name_ar' => 'required',
        'name_en' => 'required',
        'type' => 'required',
    ];

    protected $fillable = [
        'name',
        'type',
        'model',
        'company_id',
    ];

    public $translatable = ['name'];

    public function company()
    {
        return $this->belongsTo(Company::class);
    }
}
