<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class BillSellNature extends Model
{
    use HasFactory;

    protected $fillable = [
        'bill_id',
        'main_sell_nature_id',
        'selling_type',
        'selling_id',
        'model',
        'resource',
        'value',
    ];

    protected $casts = [
        'value' => 'json',
    ];

    public function selling()
    {
        return $this->morphTo('selling');
    }

    public function bill()
    {
        return $this->belongsTo(Bill::class);
    }

    public function sellNature()
    {
        return $this->belongsTo(MainSellNature::class);
    }
}
