<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class BillService extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'service_id',
        'branch_id',
        'bill_id',
        'discount_type',
        'discount_amount',
        'tax_included',
        'tax_id',
        'date',
        'quantity',
        'quantity',
        'starts_at',
    ];

    protected $casts = [
        'tax_included' => 'boolean',
    ];

    public function tax()
    {
        return $this->belongsTo(Tax::class);
    }

    public function getDiscountAmountAttribute($value)
    {
        return $value / 100;
    }

    public function setDiscountAmountAttribute($value)
    {
        $this->attributes['discount_amount'] = $value * 100;
    }

    public function getPriceAttribute($value)
    {
        return $value / 100;
    }

    public function setPriceAttribute($value)
    {
        $this->attributes['price'] = $value * 100;
    }

    public function service()
    {
        return $this->belongsTo(Service::class);
    }

    public function bill()
    {
        return $this->belongsTo(Bill::class);
    }
}
