<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Spatie\Translatable\HasTranslations;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class BlockReason extends Model
{
    use HasFactory, HasTranslations;

    const KEY = 'block_reason';

    const ROLE = [
        'dropdown_name_ar' => 'required',
        // 'option_value_ar' => 'required',

        'dropdown_name_en' => 'required',
        // 'option_value_en' => 'required',

        'dropdown_name' => 'nullable',
        // 'option_value' => 'nullable',
    ];

    protected $table = 'dropdown_options';

    protected $translatable  = [
        'dropdown_name',
        'option_value',
    ];

    protected $fillable = [
        'company_id',
        'dropdown_name', // value to show the user in dropdown
        'option_value', // i have no idea what this is
        'option_label', // used in where clause
    ];

    public function company()
    {
        $this->belongsTo(Company::class);
    }
}
