<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class BlockSupplier extends Model
{
    use HasFactory;

    const RULE = [
        'supplier_id' => 'required|exists:suppliers,id|unique:block_suppliers,supplier_id',
        'reason_id' => 'required|exists:dropdown_options,id',
        'note' => 'required',
        'date' => 'required',
        'status' => 'required',
    ];

    protected $fillable = [
        'company_id',
        'supplier_id',
        'reason_id',
        'note',
        'date',
        'status',
    ];

    public function blockReason()
    {
        return $this->belongsTo(BlockReason::class, 'reason_id');
    }

    public function supplier()
    {
        return $this->belongsTo(Supplier::class);
    }

    public function company()
    {
        return $this->belongsTo(Company::class);
    }
}
