<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Spatie\Translatable\HasTranslations;
use App\Http\Enums\Branch\BranchTypeEnum;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;


class Branch extends Model
{
    use HasFactory, HasTranslations, SoftDeletes;

    const RULES = [
        'name_ar' => 'required|string',
        'name_en' => 'nullable|string',
        'name' => 'nullable|array',
        'address_id'=> 'nullable|exists:addresses,id',
        'phone_1' => 'nullable',
        'phone_2' => 'nullable',
        'email' => 'nullable|email',
        'website' => 'nullable',
        'type' => 'required|in:main,sub',
        // 'manager_fname' => 'nullable',
        // 'manager_lname' => 'nullable',
        // 'gender' => 'nullable|in:male,female',
        // 'home_service' => 'nullable|boolean',
        // 'beauty_expert' => 'nullable|boolean',
        'delivers' => 'nullable|boolean',
        'group_settings_id' => 'nullable|exists:group_settings,id',
        'number_of_employees' => 'nullable|between:1,3',
        // 'job_types' => 'nullable|array',
        // 'job_types.*' => 'nullable|exists:job_types,id',
    ];

    protected $fillable = [
        'company_id',
        'name',
        'address_id',
        'phone_1',
        'phone_2',
        'type',
        'email',
        'website',
        // 'manager_fname',
        // 'manager_lname',
        // 'gender',
        'home_service',
        'beauty_expert',
        'delivers',
        'group_settings_id',
        'number_of_employees',
    ];

    protected $casts = [
        'type' => BranchTypeEnum::class,
    ];

    public $translatable = ['name'];

    public function address()
    {
        return $this->belongsTo(Address::class, 'address_id');
    }

    public function dismissalNotice()
    {
        return $this->hasMany(DismissalNotice::class);
    }

    public function deliveries()
    {
        return $this->hasMany(Delivery::class);
    }

    // public function users()
    // {
    //     return $this->morphedByMany(User::class, 'branchable');
    // }

    public function warehouses()
    {
        return $this->belongsToMany(Warehouse::class);
    }

    public function groupSetting()
    {
        return $this->belongsTo(GroupSetting::class);
    }

    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    // public function jobTypes()
    // {
    //     return $this->belongsToMany(JobType::class, 'branch_job_types', 'branch_id', 'job_type_id');
    // }

    public function services()
    {
        return $this->belongsToMany(Service::class);
    }

    public function employees()
    {
        return $this->hasMany(Employee::class);
    }

    public function employeeTransactions()
    {
        return $this->hasMany(EmployeeTransaction::class);
    }

    public function bills()
    {
        return $this->hasMany(Bill::class);
    }
}
