<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use App\Http\Resources\DismissalNoticeResource;
use Illuminate\Database\Eloquent\Factories\HasFactory;


class DismissalNotice extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'product_id',
        'warehouse_id',
        'branch_id',
        'quantity',
        'use_quantity',
    ];

    public function resolveResource()
    {
        return DismissalNoticeResource::class;
    }

    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    public function warehouse()
    {
        return $this->belongsTo(Warehouse::class);
    }

    public function branch()
    {
        return $this->belongsTo(Branch::class);
    }

    public function getUseQuantityAttribute($value)
    {
        return $value / 100;
    }

    public function setUseQuantityAttribute($value)
    {
        $this->attributes['use_quantity'] = $value * 100;
    }
}
