<?php

namespace App\Models;

use Laravel\Sanctum\HasApiTokens;
use Spatie\Permission\Traits\HasRoles;
use Illuminate\Database\Eloquent\Model;
use Spatie\Translatable\HasTranslations;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

class Employee extends Authenticatable
{
    use HasFactory, HasTranslations, SoftDeletes, HasRoles, HasApiTokens, Notifiable;

    const RULES = [
        'name' => 'nullable',
        'name_ar' => 'required',
        'name_en' => 'required',
        'birth_date' => 'required|date',
        'identity_type' => 'required|integer',
        'ID_number' => 'required|string',
        'hiring_date' => 'required|date',
        'status' => 'required|boolean',
        'online' => 'required|boolean',
        'calendar_appearance' => 'required|boolean',
        'attendance_method_id' => 'required|exists:attendance_methods,id',
        'section_id' => 'required|exists:careers_sections,id',
        'career_id' => 'required|exists:careers_sections,id',
        'branch_id' => 'required|exists:branches,id',
    ];

    const PASSWORD = 'password';

    protected $fillable = [
        'company_id',
        'name',
        'code',
        'phone',
        'email',
        'birth_date',
        'identity_type',
        'ID_number',
        'hiring_date',
        'status',
        'online',
        'calendar_appearance',
        'attendance_method_id',
        'section_id',
        'career_id',
        'address_id',
        'branch_id',
        'password',
        'worker_id',
    ];

    protected $translatable = [
        'name',
    ];

    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    public function journals()
    {
        return $this->hasMany(Journal::class);
    }

    public function worker()
    {
        return $this->hasOne(Worker::class);
    }

    public function absences()
    {
        return $this->hasMany(Absence::class);
    }

    public function vacations()
    {
        return $this->hasMany(VacationRequest::class, 'employee_id');
    }

    public function vacationsRequests()
    {
        return $this->hasMany(VacationRequest::class, 'substitute_employee_id');
    }

    public function attendanceMethod()
    {
        return $this->belongsTo(AttendanceMethod::class);
    }

    public function section()
    {
        return $this->belongsTo(Section::class)->where('type', Section::SECTION_TYPE);
    }

    public function career()
    {
        return $this->belongsTo(Career::class)->where('type', Career::CAREER_TYPE);
    }

    public function branch()
    {
        return $this->belongsTo(Branch::class);
    }

    public function address()
    {
        return $this->belongsTo(Address::class);
    }

    public function employeeTransactions()
    {
        return $this->hasMany(EmployeeTransaction::class);
    }

    public function delivery()
    {
        return $this->hasMany(Delivery::class);
    }
}
